####################################
# MH PBMCC Checker
# by ManiHoni
# Copyright 2011 - All Rights reserved
# manihoni2008@gmail.com
# http://www.manihoni.net/
####################################
import poser
ver = " Ver1.0"
name = "MH PBMCC Checker" + ver + " > "
i_c = 0
fig = poser.Scene().CurrentFigure()

if fig is None:
	print name + "Caution"
	print name + "Figure is not found"
	print "--------------------------------------------"

else:
	s_fname = fig.Name()
	a = poser.Scene().CurrentActor() 
	s_aname = a.Name()
	
	if a.IsHairProp():
		s_a = "Hair"
	elif a.IsProp():
		s_a = "Prop"
	elif a.ItsFigure():
		s_a = "Part"
	else:
		s_a = "object"
	
	print name + "Selected figure is \"" + s_fname + "\""
	print name + "Selected " + s_a + " is \"" + s_aname + "\""

	list_para = a.Parameters()

	for p in list_para:
		s_in =  p.InternalName()

		if -1 < s_in.find("PBMCC"):
			if i_c == 0:
				print ""

			i_c = i_c+1
			s_n = p.Name()
			i_h = p.Hidden()
			if 0 == i_h:
				s_h = " o "
			else:
				s_h = " x "
			print s_in + s_h + s_n

	if i_c == 0:
		print name  + "This " + s_a + " does't have PBMCC"
	else:
		print ""

	print name  + "Finish"	
	print "--------------------------------------------"
####################################